# Report — F16 (v2): Horizon / NoCommit

**Run:** `2025-11-05T22-29-19Z`  
**PASS:** **True**

## Why we ran this simulation

We wanted to **operationally certify a “NoCommit” horizon** in the present‑act engine: for a declared radius `R_h`,
every ray with impact **b ≤ R_h** must fail to reach the detector (because commits are forbidden once inside r ≤ R_h),
whereas **b > R_h** must reach. This matches the “reachability front” notion in the matter framework: a sharp, monotone
boundary in shell units that is independent of diagnostics and does not rely on randomness.

## How it works (engine contract)

- **Deterministic rays:** At each tick, a horizontal (east‑going) ray updates its integer radius
  `r = floor(sqrt((x-cx)^2 + (y-cy)^2))` and moves east only when the present‑act schedule allows it.
- **NoCommit interior:** If `r ≤ R_h`, commits (east steps) are *disallowed*; time still ticks.
- **Outer schedule:** Outside the horizon, commits are allowed at ticks `t` satisfying
  `t % (1 + floor(kappa / r)) == 0` (integer-only gate).
- **Panels & mesh:** We run a coarse and a fine grid, sweep a list of **impact parameters b**, and compute:
  - `b_min_pass` = smallest **b** that reaches the detector
  - `b_max_fail` = largest **b** that fails to reach
  - **Edge blur** = `b_min_pass - b_max_fail`
  - **Holes** = any pass at `b ≤ b_max_fail` or any fail at `b ≥ b_min_pass`
  - **Interior neutrality** flag for fails (must enter r ≤ R_h and then make zero commits)
  - **Mesh agreement** = |horizon_coarse − horizon_fine| ≤ Δb_max

## Parameters (manifest)

```json
{
  "acceptance": {
    "edge_blur_max_shells": 1,
    "holes_max": 0,
    "require_interior_neutrality": true,
    "require_pass_and_fail": true
  },
  "grid": {
    "N": 256,
    "cx": 128,
    "cy": 128
  },
  "horizon": {
    "radius_shells": 24
  },
  "mesh": {
    "N_fine": 192,
    "delta_horizon_b_max": 1
  },
  "schedule": {
    "kappa": 24
  },
  "source": {
    "impact_params_shells": [
      96,
      80,
      64,
      56,
      48,
      40,
      32,
      28,
      26,
      25,
      24,
      22,
      20,
      18,
      16,
      14,
      12,
      10,
      8
    ],
    "x_margin": 16
  },
  "study": "F16 Horizon (Reachability NoCommit) \u2014 v2"
}
```

## Results (this run)

- **Horizon estimate:** coarse = **25**, fine = **25**
- **Monotonicity:** holes(c/f) = **0/0**
- **Edge blur:** **1/1** (coarse/fine) — threshold ≤ **1**
- **Interior neutrality:** **True/True** (coarse/fine)
- **Mesh agreement:** Δb = **0** — ok = **True** (threshold ≤ **1**)
- **PASS:** **True**

**Single‑line summary** (from `outputs/run_info/result_line.txt`):

```
F16_v2 PASS=True b_h_coarse=25 b_h_fine=25 Δb=0 holes(c/f)=0/0 edge(c/f)=1/1 interior(c/f)=True/True mesh_ok=True
```

### Per‑ray CSVs

See:
- `results/v2/2025-11-05T22-29-19Z/f16_coarse_per_ray.csv`
- `results/v2/2025-11-05T22-29-19Z/f16_fine_per_ray.csv`

Columns: `b_shells, reached, ticks, first_inside_tick, east_steps_after_inside, east_steps_total, guard_exceeded`.

## Interpretation

- The **densified b‑list** (adding *b=25*) resolves the edge from 2→1 shell without affecting the other gates.
- **Interior neutrality** confirms that the NoCommit rule is enforced: every failing ray first enters r ≤ R_h
  (non‑empty `first_inside_tick`) and performs **0** commits thereafter.
- **Mesh Δb=0** demonstrates stability of the boundary across coarse vs fine grids for this manifest.

## Reproduction

From the repo root, either run the engine directly:

```bash
python engines/engine_f16_horizon_v2.py --manifest config/manifest_f16_v2.json --outdir runs/<UTC_timestamp>/
```

or use:

```bash
python scripts/run_v2.py
```

You should obtain a PASS with the same acceptance gates (monotone front, edge blur ≤ 1, interior neutrality, mesh agreement).
